#!/bin/sh

if [ "${#}" -ne 5 ]; then
	echo "Usage: scp_put ESXI_HOST ESXI_USERNAME ESXI_PASSWORD SOURCE DESTINATION"
	exit 1
fi

esxi_host="${1}"
esxi_username=`printf "%q" "${2}"`
esxi_password=`printf "%q" "${3}"`
source="${4}"
destination="${5}"

expect -c "spawn scp -q \"${source}\" \"${esxi_username}@${esxi_host}:${destination}\"
set timeout 3600
expect \"*?assword:*\"
send -- \"${esxi_password}\\r\"
expect eof" 2>&1

